function dataPresenter

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Present summarized data regarding link-properties of IEEE 802.11b
%
% Author: Hongwei Zhang (zhangho@cse.ohio-state.edu)
% Date: Sept. 13, 2004 -
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear
clc
close all

%constants
HAS_MAC_LATENCY_DATA = 1; %0: no      1: yes
USE_UNIX_MATLAB = 0; %0: no     1: yes
if ~USE_UNIX_MATLAB
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\osu-airport\3ft-separation\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\osu-airport\12-and-6-ft-separation\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\1km-135ft-separation\parsedData';
    %SOURCE_DATA_DIR = 'D:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\1km-135ft-separation\unicast-0-retry\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\Avon-park\broadcast\parsedData\interferer-free';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\Avon-park\broadcast\parsedData\with-interferer';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\Avon-park\unicast\parsedData\interferer-free';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\Avon-park\unicast\parsedData\with-interferer';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\testbed-attenuator\40db\power-127\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\testbed-attenuator\40db\power-128\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\kansei\unicast\row7\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\kansei\broadcast\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\kansei\broadcast\30bytes\parsedData';
    %SOURCE_DATA_DIR = 'E:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\kansei\broadcast\diffPowerLevels\parsedData';
    %SOURCE_DATA_DIR = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-0\parsedData\2';
    %SOURCE_DATA_DIR = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-0\parsedData\3';
    %SOURCE_DATA_DIR = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\parsedData';
    %SOURCE_DATA_DIR = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-0\parsedData';
    %SOURCE_DATA_DIR = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-1\parsedData';
    %SOURCE_DATA_DIR = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-power2\parsedData';
    SOURCE_DATA_DIR = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-power1\parsedData';
else 
    %SOURCE_DATA_DIR = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/osu-airport/3ft-separation/parsedData';
    %SOURCE_DATA_DIR = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/osu-airport/12-and-6-ft-separation/parsedData';
    %SOURCE_DATA_DIR = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/1km-135ft-separation/parsedData';
    %SOURCE_DATA_DIR = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/1km-135ft-separation/unicast-0-retry/parsedData';
end

DATA_IS_FOR_BROADCAST = 1;%1;%0; 

TESTING_LINK_SYMMETRIC_SIMILARITY = 0;

Y_DISTS_ABS_TO_CONSIDER = [0 1 2 3 4 5 6];%[0],[1],[2],[3],[4],[5],[6];  %since avon-park
SHOW_MAC_LATENCY_DETAIL = 0; %1: yes      0: no;   time series, histogram
TIME_SERIES_GRANULARITY = 33; %every so many samples
PKT_PERIODS_TO_DETAIL = [];% [100 10]; %controls the presentation of per-distance
                                       %packet delivery rate: time series, histogram

NO_FILTERING_BASED_ON_FILE_PREFIX = 0; %1: for the very old data
%PARSED_FILE_PREFIX =
%['link_data_parsed_avon-park-broadcast-interferer-free_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['link_data_parsed_avon-park-broadcast-with-interferer_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['link_data_parsed_avon-park-unicast-interferer-free_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['link_data_parsed_avon-park-unicast-with-interferer_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_testbed-40db-power-127_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_testbed-40db-power-128_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-unicast-interferer-free_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-unicast-interfer-sym_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-unicast-interfer-far_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-unicast-interfer-middle_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-unicast-interfer-close_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-unicast-interfer-all_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-unicast-interfer-exscal_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-interferer-free_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX =['parsed_kansei-broadcast-diffPowerLevels-special-power62_' num2str(Y_DISTS_ABS_TO_CONSIDER)]; %SIMULATE INTERFERER FREE
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-interfer-sym_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-interfer-far_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-interfer-middle_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-interfer-close_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-interfer-all_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-interfer-exscal_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-30bytes-interferer-free_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-diffPowerLevels-special-power128_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-diffPowerLevels-special-power42_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-diffPowerLevels-special-power62_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['parsed_kansei-broadcast-diffPowerLevels-special-power148_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-mote-broadcast-power2-power1-2-3_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-mote-broadcast-power3-power1-2-3_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-mote-broadcast-power3-data_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-mote-broadcast-power6-data_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-mote-broadcast-power9-data_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-tmote-broadcast-power1-power1-2-3_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-tmote-broadcast-power2-power1-2-3_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-tmote-broadcast-power3-power1-2-3_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = ['kansei-mote-broadcast-power3-power1-2-3_' num2str(Y_DISTS_ABS_TO_CONSIDER)];
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-unicast-power3-03-12-07a-noMac-unicast_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-interferer-free-diagonal-12_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-unicast-power3-diagonal-12_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-LM-xsm-interferer-close_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-LM-xsm-interferer-middle_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-LM-xsm-interferer-far_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-free_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-close_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-middle_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-far_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-free_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-close_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-middle_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-far_';
%PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power2-xsm-interferer-free_';
PARSED_FILE_PREFIX = 'parsed-kansei-xsm-broadcast-power1-xsm-interferer-free_';

MIN_MAC_LATENCY = 0;%1000; %microseconds

PKT_SIZES = [30 1200]; %[30 1200]; %30 bytes for tmote
BROADCAST = 0; UNICAST = 1;
PKT_TYPES = [BROADCAST UNICAST]; %0: is broadcast     1: unicast

PKT_PERIOD_LEN = [1000 100];%100000 10000 10]; %number of packets
TIME_PERIOD_LEN = [60000000 30000000 1000000 500000 100000]; %microseconds

FEET_PER_METER = 3.28;

LINES_PER_FIGURE = 5; %control the number of lines (i.e., data for diff. distances) per figure


%Present the data regarding each packet type and each packet size
deliveryRateMeanStdCovMedian = []; %pkt-type  pkt-size  pkt-period  distance mean  std  cov
macLatencyMeanStdCov = []; %pkt-type  pkt-size  distance mean std cov
macLatencySuccMeanStdCov = []; %pkt-type  pkt-size  distance mean std cov
for pktTypeIndex = 1:length(PKT_TYPES) %broadcast, unicast
    for pktSizeIndex = 1:length(PKT_SIZES)
        disp(['Processing' '  pkt-type = ' num2str(PKT_TYPES(pktTypeIndex)) '   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ': please wait ...']);
        %------------------------------------------------------------------
        % 1) present the delivery rate as a function of distance; also the
        %    variance per different packet periods
        for lenIndex = 1:length(PKT_PERIOD_LEN)
            toPresent = []; %Format: distance   delivery-rate
            %get the files for all distances
            clear parsedDataFiles
            parsedDataFiles = dir(SOURCE_DATA_DIR);
            for fileIndex = 1:length(parsedDataFiles)  %per distances
                if parsedDataFiles(fileIndex).isdir
                    continue
                end
                shouldConsiderThisFile = 0;
                if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                    for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                        if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                            shouldConsiderThisFile = 1;
                            break;
                        end
                    end
                end
                if shouldConsiderThisFile == 0
                    continue
                end
                %disp(['      ' parsedDataFiles(fileIndex).name]);
                if ~USE_UNIX_MATLAB
                    parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
                else                     
                    parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
                end
                sumData = parsedData.sumData; 
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                deliveryRate = sumData.deliveryRatePktPeriod; 
                %get the indices of the related data item
                itemsOfType = find(deliveryRate(:, 1) == PKT_TYPES(pktTypeIndex));
                itemsOfSize = find(deliveryRate(:, 2) == PKT_SIZES(pktSizeIndex));
                itemsOfPeriod = find(deliveryRate(:, 3) == PKT_PERIOD_LEN(lenIndex));                
                itemsToPresent = intersect(intersect(itemsOfType, itemsOfSize), itemsOfPeriod);
                if isempty(itemsToPresent)
                    continue
                end
                %assemble to data to present for this parameter set, and this distance
                rateToPresent = deliveryRate(itemsToPresent, 4);
                len = size(toPresent, 1);
                for index = 1:length(rateToPresent)
                    toPresent(len + index, 1) = sumData.distance;
                    toPresent(len + index, 2) = rateToPresent(index);
                end
                %compute the mean, varian, cov, median
                meanRate = mean(rateToPresent);
                stdRate = std(rateToPresent);
                medianRate = median(rateToPresent);
                if DATA_IS_FOR_BROADCAST == 0 %is for unicast
                    deliveryRateMeanStdCovMedian = [deliveryRateMeanStdCovMedian; ...
                                              [PKT_TYPES(pktTypeIndex) PKT_SIZES(pktSizeIndex) PKT_PERIOD_LEN(lenIndex) ...
                                               sumData.distance meanRate stdRate stdRate/meanRate medianRate]...
                                             ];
                else %is for broadcast
                    estRates = UCQualityEstimationViaBC(rateToPresent);
                    deliveryRateMeanStdCovMedian = [deliveryRateMeanStdCovMedian; ...
                                              [PKT_TYPES(pktTypeIndex) PKT_SIZES(pktSizeIndex) PKT_PERIOD_LEN(lenIndex) ...
                                               sumData.distance meanRate stdRate stdRate/meanRate medianRate ...
                                               mean(estRates) std(estRates)/mean(estRates) ...
                                              ]...
                                             ];
                end
                %%further analysis of the packet rate for this distance
                if ~isempty(find(PKT_PERIODS_TO_DETAIL == PKT_PERIOD_LEN(lenIndex)))
                    %time series
                    figure('Name', ['Time series of packet-delivery-rate: granularity =' num2str(PKT_PERIOD_LEN(lenIndex)) '   distance = ' num2str(sumData.distance) ' feet']);
                    plot(rateToPresent * 100);
                    set(gca, 'FontSize', 30);
                    xlabel('time series');
                    ylabel('packet delivery rate (%)');
                    title(['Packet-delivery-rate: granularity =' num2str(PKT_PERIOD_LEN(lenIndex)) '   distance = ' num2str(sumData.distance) ' feet']);
                    %histogram                    
                    figure('Name', ['Histogram of packet-delivery-rate: granularity =' num2str(PKT_PERIOD_LEN(lenIndex)) '   distance = ' num2str(sumData.distance) ' feet']);
                    hist(rateToPresent * 100, length(unique(rateToPresent)));
                    set(gca, 'FontSize', 30);
                    xlabel('packet delivery rate (%)');
                    ylabel('frequency');
                    title(['Packet-delivery-rate: granularity =' num2str(PKT_PERIOD_LEN(lenIndex)) '   distance = ' num2str(sumData.distance) ' feet']);
                end
                
                %to save memory
                clear parsedData sumData deliveryRate itemsOfType itemsOfSize itemsOfPeriod itemsToPresent
            end %distance
            if isempty(toPresent)
                continue
            end
            %show the sumarized data: distance vs. mean std cov
            disp(['pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                  '  # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);
            itemsToShow = find(deliveryRateMeanStdCovMedian(:, 1) == PKT_TYPES(pktTypeIndex));
            itemsToShow = intersect(itemsToShow, find(deliveryRateMeanStdCovMedian(:, 2) == PKT_SIZES(pktSizeIndex)));
            itemsToShow = intersect(itemsToShow, find(deliveryRateMeanStdCovMedian(:, 3) == PKT_PERIOD_LEN(lenIndex)));
            PDR_dist_mean_std_cov_median = deliveryRateMeanStdCovMedian(itemsToShow, 4:8); %distance mean std cov median
            PDR_dist_mean_std_cov_median = sortrows(PDR_dist_mean_std_cov_median, 1)
            clear PDR_dist_mean_std_cov_median
            %present the data in a new figure
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                figure('Name', ['BROADCAST delivery rate: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);
            else 
                figure('Name', ['UNICAST delivery rate: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);            
            end
            scatter(toPresent(:, 1) / FEET_PER_METER, toPresent(:, 2)*100, '*');
            %grid on;
            set(gca, 'FontSize', 30, 'YGrid', 'on');
            xlabel('distance (meter)');
            ylabel('packet delivery rate (%)');
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                title(['BROADCAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);
            else 
                title(['UNICAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);            
            end
            %present the data in BOXPLOT
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                figure('Name', ['BROADCAST delivery rate (boxplot): ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);
            else 
                figure('Name', ['UNICAST delivery rate (boxplot): ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);            
            end
            boxplot(toPresent(:, 2)*100, toPresent(:, 1), 'notch', 'on');
            set(gca, 'FontSize', 30);
            xlabel('distance (meter) /3.28');
            ylabel('packet delivery rate (%)');
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                title(['BROADCAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);
            else 
                title(['UNICAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
                                '   # of packets per period = ' num2str(PKT_PERIOD_LEN(lenIndex))]);            
            end            
            %to save memory
            clear toPresent parsedDataFiles 
        end %packet period        
        disp('      ... in progress ...');
        
        
        %------------------------------------------------------------------
        % 2) present the delivery rate per different time periods, and per
        %    different distances; i.e., temporal properties
        %         for lenIndex = 1:length(TIME_PERIOD_LEN)
        %             titleStr = [];
        %             numLinesInTheFigure = 0;
        %             stdDevAndCovToPresent = []; %format: distance  std-dev  cov(coefficient of variation)
        %             %get the files for all distances
        %             parsedDataFiles = dir(SOURCE_DATA_DIR);
        %             for fileIndex = 1:length(parsedDataFiles)  %per distances
%                 if parsedDataFiles(fileIndex).isdir
%                     continue
%                 end
%                 shouldConsiderThisFile = 0;
%                 if ~NO_FILTERING_BASED_ON_FILE_PREFIX
%                     for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
%                         if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
%                             shouldConsiderThisFile = 1;
%                             break;
%                         end
%                     end
%                 end
%                 if shouldConsiderThisFile == 0
%                     continue
%                 end
        %                 if ~USE_UNIX_MATLAB
        %                     parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
        %                 else
        %                     parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
        %                 end
        %                 sumData = parsedData.sumData;
%                 if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
%                     sumData.distance = abs(sumData.distance);
%                 end
        %                 deliveryRate = sumData.deliveryRateTimePeriod;
        %                 %get the indices of the related data item
        %                 itemsOfType = find(deliveryRate(:, 1) == PKT_TYPES(pktTypeIndex));
        %                 itemsOfSize = find(deliveryRate(:, 2) == PKT_SIZES(pktSizeIndex));
        %                 itemsOfPeriod = find(deliveryRate(:, 3) == TIME_PERIOD_LEN(lenIndex));
        %                 itemsToPresent = intersect(intersect(itemsOfType, itemsOfSize), itemsOfPeriod);
        %                 if isempty(itemsToPresent)
        %                     continue
        %                 end
        %                 %assemble to data to present for this parameter set
        %                 toPresent = []; %format: time(microseconds)  delivery rate
        %                 rateToPresent = deliveryRate(itemsToPresent, 4);
        %                 for index = 1:length(rateToPresent)
        %                     toPresent(index, 1) = TIME_PERIOD_LEN(lenIndex) * index;
        %                     toPresent(index, 2) = rateToPresent(index);
        %                 end
        %                 %draw the figure(s)
        %                 if mod(numLinesInTheFigure, LINES_PER_FIGURE) == 0
        %                     figure('Name', 'Temporal property of delivery rate at diff. distances');
        %                     titleStr = [num2str(sumData.distance) ', '];
        %                 elseif mod(numLinesInTheFigure, LINES_PER_FIGURE) ~= LINES_PER_FIGURE - 1
        %                     titleStr = [titleStr num2str(sumData.distance) ', '];
        %                 else
        %                     titleStr = [titleStr num2str(sumData.distance)];
        %                 end
        %                 numLinesInTheFigure = numLinesInTheFigure +1;
        %                 plot(toPresent(:, 1), toPresent(:, 2)*100);
        %                 text(toPresent(1, 1), toPresent(1, 2)*100, [' \leftarrow distance=' num2str(sumData.distance) 'ft']);
        %                 hold on;
        %                 if mod(numLinesInTheFigure, LINES_PER_FIGURE) == 0 || fileIndex == length(parsedDataFiles)
        %                     grid off;
        %                     set(gca, 'FontSize', 30);
        %                     xlabel('Time (microseconds)');
        %                     ylabel('Delivery rate (%)');
        %                     if PKT_TYPES(pktTypeIndex) == BROADCAST
        %                         title(['BROADCAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
        %                                 '   time-period = ' num2str(TIME_PERIOD_LEN(lenIndex)) '  distances = ' titleStr]);
        %                     else
        %                         title(['UNICAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
        %                                 '   time-period = ' num2str(TIME_PERIOD_LEN(lenIndex)) '  distances = ' titleStr]);
        %                     end
        %                 end
        %                 %%calculate the coefficient of variation as well as the std-dev for this distance
        %                 meanDeliveryRate = mean(rateToPresent);
        %                 stdDeliveryRate = std(rateToPresent);
        %                 len = size(stdDevAndCovToPresent, 1);
        %                 %
        %                 stdDevAndCovToPresent(len+1, 1) = sumData.distance;
        %                 stdDevAndCovToPresent(len+1, 2) = stdDeliveryRate;
        %                 stdDevAndCovToPresent(len+1, 3) = stdDeliveryRate/meanDeliveryRate;   %c.o.v.
        %                 %
        %                 meanDR(len+1, 1) = sumData.distance;
        %                 meanDR(len+1, 2) = meanDeliveryRate;
        %                 %to save memory
        %                 clear parsedData sumData deliveryRate itemsOfType itemsOfSize itemsOfPeriod itemsToPresent toPresent rateToPresent len
        %             end %distances
        %             if exist('meanDR') && ~isempty(meanDR)
        %                 meanDR = sortrows(meanDR, 1);
        %                 save(['meanDR' '-time-period-' num2str(TIME_PERIOD_LEN(lenIndex)) '.mat'], 'meanDR');
        %             end
        %             %present the c.o.v. as a function of distance in a single figure
        %             if ~isempty(stdDevAndCovToPresent)
        %                 stdDevAndCovToPresent = sortrows(stdDevAndCovToPresent, 1)
        %                 save(['stdDevAndCovToPresent' '-time-period-' num2str(TIME_PERIOD_LEN(lenIndex)) '.mat'], 'stdDevAndCovToPresent'); %distance   std   c.o.v.
        %                 figure('Name', 'C.O.V. of packet delivery rate as a function of distance');
        %                 plot(stdDevAndCovToPresent(:, 1), stdDevAndCovToPresent(:, 2)*100, '-+b', 'MarkerSize', 14);
        %                 hold on;
        %                 plot(stdDevAndCovToPresent(:, 1), stdDevAndCovToPresent(:, 3)*100, '--*r', 'MarkerSize', 14);
        %                 legend('Standard deviation', 'Coefficient of variation');
        %                 grid off;
        %                 set(gca, 'FontSize', 30);
        %                 xlabel('Distance (feet)');
        %                 ylabel('STD-DEV and C.O.V. of delivery rate (%)');
        %                 if PKT_TYPES(pktTypeIndex) == BROADCAST
        %                     title(['BROADCAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
        %                             '   time-period = ' num2str(TIME_PERIOD_LEN(lenIndex))]);
        %                 else
        %                     title(['UNICAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ...
        %                             '   time-period = ' num2str(TIME_PERIOD_LEN(lenIndex))]);
        %                 end
        %             end
        %             %to save memory
        %             clear parsedDataFiles titleStr numLinesInTheFigure stdDevAndCovToPresent
        %         end %time period
        %         disp('      ... in progress ...');

        
        %------------------------------------------------------------------
        % 3) draw figures for the length of success-bursts, per packet type
        %    and packet size; and the impact of distance too;
        %    PMFs, and error-bar;
        %    TODO: length in time (length in # of the packets has been
        %          done.)
        errorBarToPresent = []; %Format: distance, median, minimum, maximum
        scatterToPresent = []; %format: distance, burst length
        %get the files for all distances
        parsedDataFiles = dir(SOURCE_DATA_DIR);
        numLinesInTheFigure = 0;
        for fileIndex = 1:length(parsedDataFiles)  %per distances
            if parsedDataFiles(fileIndex).isdir
                continue
            end
            shouldConsiderThisFile = 0;
            if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                    if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                        shouldConsiderThisFile = 1;
                        break;
                    end
                end
            end
            if shouldConsiderThisFile == 0
                continue
            end
            if ~USE_UNIX_MATLAB
                parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
            else                     
                parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
            end
            sumData = parsedData.sumData;
            if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                sumData.distance = abs(sumData.distance);
            end
            lenSuccBursts = sumData.lenSuccessBursts;
            if isempty(lenSuccBursts)
                continue
            end
            %get the indices of the related data item
            itemsOfType = find(lenSuccBursts(:, 1) == PKT_TYPES(pktTypeIndex));
            itemsOfSize = find(lenSuccBursts(:, 2) == PKT_SIZES(pktSizeIndex));               
            itemsToPresent = intersect(itemsOfType, itemsOfSize);
            if isempty(itemsToPresent)
                continue
            end
            %fetch the burst lengths
            succBursts = lenSuccBursts(itemsToPresent, 3); %# of packets in a burst
            %put in erroBarToPresent
            len = size(errorBarToPresent, 1);
            errorBarToPresent(len+1, 1) = sumData.distance;
            %errorBarToPresent(len+1, 2) = mean(succBursts);
            errorBarToPresent(len+1, 2) = median(succBursts);
            errorBarToPresent(len+1, 3) = min(succBursts);
            errorBarToPresent(len+1, 4) = max(succBursts);
            %for scatter/box plot (more detail than errorBar)
            len = size(scatterToPresent, 1);
            for i = 1:length(succBursts)
                scatterToPresent(len+i, 1) = sumData.distance;
                scatterToPresent(len+i, 2) = succBursts(i);
            end
            clear i
            %------
            %draw the PMF for this distance            
            if mod(numLinesInTheFigure, LINES_PER_FIGURE) == 0
                figure('Name', 'PMF of the length of success-bursts');
                if fileIndex ~= length(parsedDataFiles)
                    titleStr = [num2str(sumData.distance) ', ']; 
                else 
                    titleStr = [num2str(sumData.distance)]; 
                end
            elseif mod(numLinesInTheFigure, LINES_PER_FIGURE) ~= LINES_PER_FIGURE - 1
                titleStr = [titleStr num2str(sumData.distance) ', '];
            else 
                titleStr = [titleStr num2str(sumData.distance)];
            end
            numLinesInTheFigure = numLinesInTheFigure + 1;
            burstLens = unique(succBursts);
            [n, x] = hist(succBursts, burstLens);
            plot(x, (n/length(succBursts)) * 100); 
            text(x(1), (n(1)/length(succBursts)) * 100, [' \leftarrow distance=' num2str(sumData.distance) 'ft']);        
            hold on;
            if mod(numLinesInTheFigure, LINES_PER_FIGURE) == 0 || fileIndex == length(parsedDataFiles)
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('Length of succ-bursts (# of packets)');
                ylabel('Probability (%)');
                if PKT_TYPES(pktTypeIndex) == BROADCAST
                    title(['BROADCAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) '  distances = ' titleStr]);
                else 
                    title(['UNICAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) '  distances = ' titleStr]);            
                end
            end
            %to save memory
            clear parsedData sumData lenSuccBursts itemsOfType itemsOfSize itemsToPresent succBursts len burstLens n x
        end %by distances
        %present the error bar as a function of distance
        if ~isempty(errorBarToPresent)
            errorBarToPresent = sortrows(errorBarToPresent, 1);
            len_succ_burst = errorBarToPresent
            save('len-succ-burst.mat', 'len_succ_burst'); %distance  median  min max
            
            figure('Name', 'succ-burst length as a function of distance');
            errorbar(errorBarToPresent(:, 1) / FEET_PER_METER, errorBarToPresent(:, 2), ...
                     errorBarToPresent(:, 2) - errorBarToPresent(:, 3), ...
                     errorBarToPresent(:, 4) - errorBarToPresent(:, 2));
            grid off;
            set(gca, 'FontSize', 30, 'YScale', 'log');
            xlabel('distance (meter)');
            ylabel('Success-burst length (# of packets)');        
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                title(['BROADCAST: succ-burst length as a function of distance (median)' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            else 
                title(['UNICAST: succ-burst length as a function of distance (median)' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
        end
        %moreover, use scatter or box-plot
        if ~isempty(scatterToPresent)
            figure('Name', '(boxplot) succ-burst length as a function of distance');
            %scatter(scatterToPresent(:, 1) / FEET_PER_METER, scatterToPresent(:, 2), '*');  
            boxplot(scatterToPresent(:, 2), scatterToPresent(:, 1), 'notch', 'on');
            grid off;
            set(gca, 'FontSize', 30);%, 'YScale', 'log');
            xlabel('distance (\frac{1}{3.28} metter)');
            ylabel('Success-burst length (# of packets)');        
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                title(['BROADCAST: succ-burst length as a function of distance' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            else 
                title(['UNICAST: succ-burst length as a function of distance' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
        end
        %to save memory
        clear parsedDataFiles errorBarToPresent scatterToPresent numLinesInTheFigure
        disp('      ... in progress ...');
        
        
        %------------------------------------------------------------------
        % 4) draw figures for the length of failure-bursts, per packet type
        %    and packet size        
        errorBarToPresent = []; %Format: distance, median, minimum, maximum
        scatterToPresent = []; %format: distance, burst length
        %get the files for all distances
        parsedDataFiles = dir(SOURCE_DATA_DIR);
        numLinesInTheFigure = 0;
        for fileIndex = 1:length(parsedDataFiles)  %per distances
            if parsedDataFiles(fileIndex).isdir
                continue
            end
            shouldConsiderThisFile = 0;
            if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                    if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                        shouldConsiderThisFile = 1;
                        break;
                    end
                end
            end
            if shouldConsiderThisFile == 0
                continue
            end
            if ~USE_UNIX_MATLAB
                parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
            else                     
                parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
            end
            sumData = parsedData.sumData;
            if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                sumData.distance = abs(sumData.distance);
            end
            lenFailBursts = sumData.lenFailureBursts;
            if isempty(lenFailBursts)
                continue
            end
            %get the indices of the related data item
            itemsOfType = find(lenFailBursts(:, 1) == PKT_TYPES(pktTypeIndex));
            itemsOfSize = find(lenFailBursts(:, 2) == PKT_SIZES(pktSizeIndex));               
            itemsToPresent = intersect(itemsOfType, itemsOfSize);
            if isempty(itemsToPresent)
                continue
            end
            %fetch the burst lengths
            failBursts = lenFailBursts(itemsToPresent, 3); %# of packets in a burst
            %put in erroBarToPresent
            len = size(errorBarToPresent, 1);
            errorBarToPresent(len+1, 1) = sumData.distance;
            %errorBarToPresent(len+1, 2) = mean(failBursts);
            errorBarToPresent(len+1, 2) = median(failBursts);
            errorBarToPresent(len+1, 3) = min(failBursts);
            errorBarToPresent(len+1, 4) = max(failBursts);
            %for scatter plot (more detail than errorBar)
            len = size(scatterToPresent, 1);
            for i = 1:length(failBursts)
                scatterToPresent(len+i, 1) = sumData.distance;
                scatterToPresent(len+i, 2) = failBursts(i);
            end
            clear i
            %------
            %draw the PMF for this distance            
            if mod(numLinesInTheFigure, LINES_PER_FIGURE) == 0
                figure('Name', 'PMF of the length of fail-bursts');
                if fileIndex ~= length(parsedDataFiles)
                    titleStr = [num2str(sumData.distance) ', ']; 
                else 
                    titleStr = [num2str(sumData.distance)]; 
                end
            elseif mod(numLinesInTheFigure, LINES_PER_FIGURE) ~= LINES_PER_FIGURE - 1
                titleStr = [titleStr num2str(sumData.distance) ', '];
            else 
                titleStr = [titleStr num2str(sumData.distance)];
            end
            numLinesInTheFigure = numLinesInTheFigure + 1;
            burstLens = unique(failBursts);
            [n, x] = hist(failBursts, burstLens);
            plot(x, (n/length(failBursts)) * 100); 
            text(x(1), (n(1)/length(failBursts))*100, [' \leftarrow distance=' num2str(sumData.distance) 'ft']);        
            hold on;
            if mod(numLinesInTheFigure, LINES_PER_FIGURE) == 0 || fileIndex == length(parsedDataFiles)
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('Length of fail-bursts (# of packets)');
                ylabel('Probability (%)');
                if PKT_TYPES(pktTypeIndex) == BROADCAST
                    title(['BROADCAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) '  distances = ' titleStr]);
                else 
                    title(['UNICAST: ' 'pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) '  distances = ' titleStr]);            
                end
            end            
            %to save memory
            clear parsedData sumData lenFailBursts failBursts len burstLens n x
        end %by distances
        %present the error bar as a function of distance       
        if ~isempty(errorBarToPresent)
            errorBarToPresent = sortrows(errorBarToPresent, 1);
            len_fail_burst = errorBarToPresent
            save('len-fail-burst.mat', 'len_fail_burst'); %distance  median  min max

            figure('Name', 'fail-burst length as a function of distance');
            errorbar(errorBarToPresent(:, 1) / FEET_PER_METER, errorBarToPresent(:, 2), ...
                     errorBarToPresent(:, 2) - errorBarToPresent(:, 3), ...
                     errorBarToPresent(:, 4) - errorBarToPresent(:, 2));
            grid off;
            set(gca, 'FontSize', 30, 'YScale', 'log');
            xlabel('distance (meter)');
            ylabel('Fail-burst length (# of packets)');        
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                title(['BROADCAST: fail-burst length as a function of distance (median)' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            else 
                title(['UNICAST: fail-burst length as a function of distance (median)' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
        end
        %moreover, use scatter or box-plot
        if ~isempty(scatterToPresent)
            figure('Name', '(boxplot) Fail-burst length as a function of distance');
            %scatter(scatterToPresent(:, 1) / FEET_PER_METER, scatterToPresent(:, 2), '*');
            boxplot(scatterToPresent(:, 2), scatterToPresent(:, 1), 'notch', 'on');
            grid off;
            set(gca, 'FontSize', 30);%, 'YScale', 'log');
            xlabel('distance (\frac{1}{3.28} meter)');
            ylabel('Fail-burst length (# of packets)');        
            if PKT_TYPES(pktTypeIndex) == BROADCAST
                title(['BROADCAST: fail-burst length as a function of distance' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            else 
                title(['UNICAST: fail-burst length as a function of distance' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
        end
        %to save memory
        clear parsedDataFiles errorBarToPresent scatterToPresent numLinesInTheFigure
        disp('      ... in progress ...');
        
        
        %------------------------------------------------------------------
        %5) draw the errobar for the unicast feedback-delay-success as a function of distance       
        if PKT_TYPES(pktTypeIndex) ~= BROADCAST
            errorBarToPresent = [];
            %get the files for all distances
            parsedDataFiles = dir(SOURCE_DATA_DIR);
            for fileIndex = 1:length(parsedDataFiles)  %per distances
                if parsedDataFiles(fileIndex).isdir
                    continue
                end
                shouldConsiderThisFile = 0;
                if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                    for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                        if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                            shouldConsiderThisFile = 1;
                            break;
                        end
                    end
                end
                if shouldConsiderThisFile == 0
                    continue
                end
                if ~USE_UNIX_MATLAB
                    parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
                else                     
                    parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
                end
                sumData = parsedData.sumData;
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                fbDelaySucc = sumData.fbDelaySucc;
                if isempty(fbDelaySucc)
                    continue
                end
                %get the indices of the related data item
                itemsOfType = find(fbDelaySucc(:, 1) == PKT_TYPES(pktTypeIndex));
                itemsOfSize = find(fbDelaySucc(:, 2) == PKT_SIZES(pktSizeIndex));
                itemsToPresent = intersect(itemsOfType, itemsOfSize);
                if isempty(itemsToPresent)
                    continue
                end
                %fetch the feedback delay
                fbDelayToPresent = fbDelaySucc(itemsToPresent, 3);
                %put in erroBarToPresent
                len = size(errorBarToPresent, 1);
                errorBarToPresent(len+1, 1) = sumData.distance;
                errorBarToPresent(len+1, 2) = mean(fbDelayToPresent);
                errorBarToPresent(len+1, 3) = min(fbDelayToPresent);
                errorBarToPresent(len+1, 4) = max(fbDelayToPresent);
                %to save memory
                clear sumData fbDelaySucc itemsToPresent fbDelayToPresent len 
            end %distances
            %present the error bar as a function of distance
            if ~isempty(errorBarToPresent)
                errorBarToPresent = sortrows(errorBarToPresent, 1);
                if ~isempty(errorBarToPresent)
                    figure('Name', 'Feedback delay for successful unicasts');
                    errorbar(errorBarToPresent(:, 1), errorBarToPresent(:, 2)/1000, ...
                        errorBarToPresent(:, 2)/1000 - errorBarToPresent(:, 3)/1000, ...
                        errorBarToPresent(:, 4)/1000 - errorBarToPresent(:, 2)/1000);
                    grid off;
                    set(gca, 'FontSize', 30);
                    xlabel('distance (feet)');
                    ylabel('Feedback delay (milliseconds)');
                    title(['Feedback delay for successful unicasts' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
                end
            end
            %to save memory
            clear parsedDataFiles errorBarToPresent
            disp('      ... in progress ...');
        end
        
        
        %------------------------------------------------------------------
        %5') draw the errobar for the unicast mac-latency-success as a function of distance       
        if HAS_MAC_LATENCY_DATA == 1 && PKT_TYPES(pktTypeIndex) ~= BROADCAST
            errorBarToPresent = [];
            %get the files for all distances
            parsedDataFiles = dir(SOURCE_DATA_DIR);
            for fileIndex = 1:length(parsedDataFiles)  %per distances
                if parsedDataFiles(fileIndex).isdir
                    continue
                end
                shouldConsiderThisFile = 0;
                if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                    for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                        if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                            shouldConsiderThisFile = 1;
                            break;
                        end
                    end
                end
                if shouldConsiderThisFile == 0
                    continue
                end
                if ~USE_UNIX_MATLAB
                    parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
                else                     
                    parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
                end
                sumData = parsedData.sumData;
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                macLatencySucc = sumData.macLatencySucc;
                if isempty(macLatencySucc)
                    continue
                end
                %get the indices of the related data item
                itemsOfType = find(macLatencySucc(:, 1) == PKT_TYPES(pktTypeIndex));
                itemsOfSize = find(macLatencySucc(:, 2) == PKT_SIZES(pktSizeIndex));
                itemsToPresent = intersect(itemsOfType, itemsOfSize);
                if isempty(itemsToPresent)
                    continue
                end
                %compute the mean, std, cov
                meanLatency = mean(macLatencySucc(itemsToPresent, 3));
                stdLatency = std(macLatencySucc(itemsToPresent, 3));
                macLatencySuccMeanStdCov = [macLatencySuccMeanStdCov; ...
                                            [PKT_TYPES(pktTypeIndex) PKT_SIZES(pktSizeIndex) ...
                                             sumData.distance meanLatency stdLatency stdLatency/meanLatency] ... 
                                           ];
                %fetch the feedback delay
                macLatencyToPresent = macLatencySucc(itemsToPresent, 3);
                %save this data
                save(['macLatencySucc-' num2str(sumData.distance) '-' num2str(PKT_SIZES(pktSizeIndex)) '.mat'], 'macLatencyToPresent');
                %remove outliers
                macLatencyToPresent = macLatencyToPresent(find(macLatencyToPresent >= MIN_MAC_LATENCY));
                if SHOW_MAC_LATENCY_DETAIL
                    %draw the historgram
                    figure('Name', ['Histogram for unicast mac-latency-success' '   distance = ' num2str(sumData.distance) ' feet']);
                    hist(macLatencyToPresent/1000,100);
                    set(gca, 'FontSize', 30); 
                    xlabel('MAC latency (milliseconds)');
                    ylabel('# of samples');
                    title(['Histogram for unicast mac-latency-success' '   distance = ' num2str(sumData.distance) ' feet']);
                    %                 %draw the normalized historgram (i.e., minus the min)
                    %                 figure('Name', 'Histogram for the normalized unicast mac-latency-success');
                    %                 hist(macLatencyToPresent - mean(macLatencyToPresent),150);
                    %                 xlabel('Normalized latency: microseconds');
                    %                 ylabel('# of occurrences');
                    %                 title(['Histogram for the normalized unicast mac-latency-success' '   distance = ' num2str(sumData.distance) ' feet']);
                    %draw the time series
                    figure('Name', ['Time series for unicast mac-laency-success' '   distance = ' num2str(sumData.distance) ' feet']);
                    plot(1:TIME_SERIES_GRANULARITY:length(macLatencyToPresent), macLatencyToPresent(1:TIME_SERIES_GRANULARITY:length(macLatencyToPresent))/1000);
                    set(gca, 'FontSize', 30);
                    xlabel('sample series');
                    ylabel('Mac latency (milliseconds)');
                    title(['Time series for unicast mac-latency-success' '   distance = ' num2str(sumData.distance) ' feet']);
                    % LD                    
                    figure('Name', ['Time series of log(LD)' '   distance = ' num2str(sumData.distance) ' feet']);
                    plot(1:TIME_SERIES_GRANULARITY:length(macLatencyToPresent), log(macLatencyToPresent(1:TIME_SERIES_GRANULARITY:length(macLatencyToPresent))/(1000 * sumData.distance/3.28)));
                    set(gca, 'FontSize', 30);
                    xlabel('sample series');
                    ylabel('log(LD) (ms/meter)');
                    title(['Time series of log(LD)' '   distance = ' num2str(sumData.distance) ' feet']);
                end
                %put in erroBarToPresent
                len = size(errorBarToPresent, 1);
                errorBarToPresent(len+1, 1) = sumData.distance;
                errorBarToPresent(len+1, 2) = mean(macLatencyToPresent); %mean
                errorBarToPresent(len+1, 3) = min(macLatencyToPresent); %min
                errorBarToPresent(len+1, 4) = max(macLatencyToPresent); %max
                %to save memory
                clear sumData macLatencySucc itemsToPresent macLatencyToPresent len 
            end %distances
            %present the error bar as a function of distance 
            if ~isempty(errorBarToPresent)
                errorBarToPresent = sortrows(errorBarToPresent, 1);
                mac_latency_succ = errorBarToPresent
                save('mac_latency_succ.mat', 'mac_latency_succ');

                figure('Name', 'MAC Latency for successful unicasts');
                errorbar(errorBarToPresent(:, 1)/FEET_PER_METER, ... 
                         (errorBarToPresent(:, 2)/1000), ...
                         (errorBarToPresent(:, 2)/1000 - errorBarToPresent(:, 3)/1000), ...
                         (errorBarToPresent(:, 4)/1000 - errorBarToPresent(:, 2)/1000));
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('distance (meter)');
                ylabel('MAC latency (milliseconds)');
                title(['MAC Latency (min, mean, max) for successful unicasts' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
                %for ELD routing metric
                distances = errorBarToPresent(:, 1)/FEET_PER_METER 
                ELDs = (errorBarToPresent(:, 2)/1000) ./ distances;
                figure('Name', 'ELD routing metric for KANSEI');
                plot(distances, errorBarToPresent(:, 2)/1000, '-.rs', 'MarkerSize', 12);
                hold on;
                plot(distances, ELDs, '-bv', 'MarkerSize', 12);
                grid off;
                set(gca, 'FontSize', 30);%, 'YGrid', 'on');
                %axis([0 14 1 25]);
                xlabel('distance (meter)');
                ylabel(' ');
                legend('mean MAC latency (ms)', 'ELD (ms/meter)');
                title('ELD routing metric for KANSEI');
                %And the normalized ratio of increase in mac latency as distance increases
                ratio_mac_latency_succ(:, 1) = errorBarToPresent(:, 1) / errorBarToPresent(1, 1);
                ratio_mac_latency_succ(:, 2) = errorBarToPresent(:, 2) / errorBarToPresent(1, 2);
                ratio_mac_latency_succ
                save('ratio_mac_latency_succ.mat', 'ratio_mac_latency_succ');
                figure('Name', 'Ratio of increase in the mean MAC-latency-succ as distance increses');
                plot(errorBarToPresent(:, 1) / errorBarToPresent(1, 1), ...
                     errorBarToPresent(:, 2) / errorBarToPresent(1, 2));
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('distance normalized to that of the closest receiver');
                ylabel('MAC latency normalized to that of the closest receiver');
                title(['Ratio of increase in the median MAC-latency-succ as distance increses' ...
                        ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
            %to save memory
            clear parsedDataFiles errorBarToPresent ratio_mac_latency_succ
            disp('      ... in progress ...');
        end
        
        
        %------------------------------------------------------------------
        %5") fetch the unicast macLatencyAll for further analysis
        if HAS_MAC_LATENCY_DATA == 1 && PKT_TYPES(pktTypeIndex) ~= BROADCAST
            errorBarToPresent = [];
            %get the files for all distances
            parsedDataFiles = dir(SOURCE_DATA_DIR);
            for fileIndex = 1:length(parsedDataFiles)  %per distances
                if parsedDataFiles(fileIndex).isdir
                    continue
                end
                shouldConsiderThisFile = 0;
                if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                    for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                        if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                            shouldConsiderThisFile = 1;
                            break;
                        end
                    end
                end
                if shouldConsiderThisFile == 0
                    continue
                end
                if ~USE_UNIX_MATLAB
                    parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
                else                     
                    parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
                end
                sumData = parsedData.sumData;
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                macLatencyAll = sumData.macLatencyAll;
                if isempty(macLatencyAll)
                    continue
                end
                %get the indices of the related data item
                itemsOfType = find(macLatencyAll(:, 1) == PKT_TYPES(pktTypeIndex));
                itemsOfSize = find(macLatencyAll(:, 2) == PKT_SIZES(pktSizeIndex));
                itemsToPresent = intersect(itemsOfType, itemsOfSize);
                if isempty(itemsToPresent)
                    continue
                end
                %compute the mean, std, cov
                meanLatency = mean(macLatencyAll(itemsToPresent, 3));
                stdLatency = std(macLatencyAll(itemsToPresent, 3));
                macLatencyMeanStdCov = [macLatencyMeanStdCov; ...
                                        [PKT_TYPES(pktTypeIndex) PKT_SIZES(pktSizeIndex) ...
                                         sumData.distance meanLatency stdLatency stdLatency/meanLatency] ... 
                                       ];
                %fetch the feedback delay
                macLatencyToPresent = macLatencyAll(itemsToPresent, 3:4); %[latency & status]
                %put in erroBarToPresent
                len = size(errorBarToPresent, 1);
                errorBarToPresent(len+1, 1) = sumData.distance;
                errorBarToPresent(len+1, 2) = mean(macLatencyToPresent(:, 1)); %mean
                errorBarToPresent(len+1, 3) = min(macLatencyToPresent(:, 1)); %min
                errorBarToPresent(len+1, 4) = max(macLatencyToPresent(:, 1)); %max
                %save this data
                save(['macLatencyAll-' num2str(sumData.distance) '-' num2str(PKT_SIZES(pktSizeIndex)) '.mat'], 'macLatencyToPresent');
                clear sumData macLatencyAll itemsToPresent macLatencyToPresent
            end %distances            
            if ~isempty(errorBarToPresent)
                errorBarToPresent = sortrows(errorBarToPresent, 1);
                mac_latency_all = errorBarToPresent
                save('mac_latency_all.mat', 'mac_latency_all');
            end
            
            %to save memory
            clear parsedDataFiles errorBarToPresent;
            disp('      ... in progress ...');
        end
        
        
        %------------------------------------------------------------------
        %6) draw the errobar for the unicast feedback-delay-fail as a function of distance       
        if PKT_TYPES(pktTypeIndex) ~= BROADCAST
            errorBarToPresent = [];
            %get the files for all distances
            parsedDataFiles = dir(SOURCE_DATA_DIR);
            for fileIndex = 1:length(parsedDataFiles)  %per distances
                if parsedDataFiles(fileIndex).isdir
                    continue
                end
                shouldConsiderThisFile = 0;
                if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                    for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                        if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                            shouldConsiderThisFile = 1;
                            break;
                        end
                    end
                end
                if shouldConsiderThisFile == 0
                    continue
                end
                if ~USE_UNIX_MATLAB
                    parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
                else                     
                    parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
                end
                sumData = parsedData.sumData;
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                fbDelayFail = sumData.fbDelayFail;
                if isempty(fbDelayFail)
                    continue
                end
                %get the indices of the related data item
                itemsOfType = find(fbDelayFail(:, 1) == PKT_TYPES(pktTypeIndex));
                itemsOfSize = find(fbDelayFail(:, 2) == PKT_SIZES(pktSizeIndex));
                itemsToPresent = intersect(itemsOfType, itemsOfSize);
                if isempty(itemsToPresent)
                    continue
                end
                %fetch the feedback delay
                fbDelayToPresent = fbDelayFail(itemsToPresent, 3);
                %put in erroBarToPresent
                len = size(errorBarToPresent, 1);
                errorBarToPresent(len+1, 1) = sumData.distance;
                errorBarToPresent(len+1, 2) = mean(fbDelayToPresent);
                errorBarToPresent(len+1, 3) = min(fbDelayToPresent);
                errorBarToPresent(len+1, 4) = max(fbDelayToPresent);
                %to save memory
                clear parsedData sumData fbDelayFail itemsToPresent fbDelayToPresent len 
            end  %distances
            %present the error bar as a function of distance
            if ~isempty(errorBarToPresent)
                figure('Name', 'Feedback delay for failed unicasts');
                errorBarToPresent = sortrows(errorBarToPresent, 1);
                errorbar(errorBarToPresent(:, 1), errorBarToPresent(:, 2)/1000, ...
                         errorBarToPresent(:, 2)/1000 - errorBarToPresent(:, 3)/1000, ...
                         errorBarToPresent(:, 4)/1000 - errorBarToPresent(:, 2)/1000);
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('distance (feet)');
                ylabel('Feedback delay (milliseconds)'); 
                title(['Feedback delay for failed unicasts' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
            %to save memory
            clear parsedDataFiles
        end
                
        
        %------------------------------------------------------------------
        %6') draw the errobar for the unicast mac-latency-fail as a function of distance       
        if HAS_MAC_LATENCY_DATA == 1 && PKT_TYPES(pktTypeIndex) ~= BROADCAST
            errorBarToPresent = [];
            %get the files for all distances
            parsedDataFiles = dir(SOURCE_DATA_DIR);
            for fileIndex = 1:length(parsedDataFiles)  %per distances
                if parsedDataFiles(fileIndex).isdir
                    continue
                end
                shouldConsiderThisFile = 0;
                if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                    for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                        if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                            shouldConsiderThisFile = 1;
                            break;
                        end
                    end
                end
                if shouldConsiderThisFile == 0
                    continue
                end
                if ~USE_UNIX_MATLAB
                    parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
                else                     
                    parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
                end
                sumData = parsedData.sumData;
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                macLatencyFail = sumData.macLatencyFail;
                if isempty(macLatencyFail)
                    continue
                end
                %get the indices of the related data item
                itemsOfType = find(macLatencyFail(:, 1) == PKT_TYPES(pktTypeIndex));
                itemsOfSize = find(macLatencyFail(:, 2) == PKT_SIZES(pktSizeIndex));
                itemsToPresent = intersect(itemsOfType, itemsOfSize);
                if isempty(itemsToPresent)
                    continue
                end
                %fetch the feedback delay
                macLatencyToPresent = macLatencyFail(itemsToPresent, 3);         
                %save this data         
                save(['macLatencyFail-' num2str(sumData.distance) '-' num2str(PKT_SIZES(pktSizeIndex)) '.mat'], 'macLatencyToPresent');
                %remove outliers
                macLatencyToPresent = macLatencyToPresent(find(macLatencyToPresent >= MIN_MAC_LATENCY));
                if isempty(macLatencyToPresent)
                    continue
                end
                if SHOW_MAC_LATENCY_DETAIL
                    %draw the historgram
                    figure('Name', 'Histogram for unicast mac-latency-fail');
                    hist(macLatencyToPresent, 150);
                    title(['Histogram for unicast mac-latency-fail' '   distance = ' num2str(sumData.distance) ' feet']);
                end
                %put in erroBarToPresent
                len = size(errorBarToPresent, 1);
                errorBarToPresent(len+1, 1) = sumData.distance;
                errorBarToPresent(len+1, 2) = mean(macLatencyToPresent);
                errorBarToPresent(len+1, 3) = min(macLatencyToPresent);
                errorBarToPresent(len+1, 4) = max(macLatencyToPresent);
                %to save memory
                clear sumData macLatencyFail itemsToPresent macLatencyToPresent len 
            end %distances
            %present the error bar as a function of distance     
            if ~isempty(errorBarToPresent)
                errorBarToPresent = sortrows(errorBarToPresent, 1);
                mac_latency_fail = errorBarToPresent
                save('mac_latency_fail.mat', 'mac_latency_fail');
                
                figure('Name', 'MAC Latency for failed unicasts');
                errorbar(errorBarToPresent(:, 1), errorBarToPresent(:, 2)/1000, ...
                         errorBarToPresent(:, 2)/1000 - errorBarToPresent(:, 3)/1000, ...
                         errorBarToPresent(:, 4)/1000 - errorBarToPresent(:, 2)/1000);
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('distance (feet)');
                ylabel('MAC Latency (milliseconds)'); 
                title(['MAC Latency for failed unicasts' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
                %And the normalized ratio of increase in mac latency as distance increases                
                ratio_mac_latency_fail(:, 1) = errorBarToPresent(:, 1) / errorBarToPresent(1, 1);
                ratio_mac_latency_fail(:, 2) = errorBarToPresent(:, 2) / errorBarToPresent(1, 2);
                ratio_mac_latency_fail
                save('ratio_mac_latency_fail.mat', 'ratio_mac_latency_fail');
                figure('Name', 'Ratio of increase in the mean MAC-latency-fail as distance increses');
                plot(errorBarToPresent(:, 1) / errorBarToPresent(1, 1), ...
                     errorBarToPresent(:, 2) / errorBarToPresent(1, 2));
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('distance normalized to that of the closest receiver');
                ylabel('MAC latency normalized to that of the closest receiver');
                title(['Ratio of increase in the mean MAC-latency-fail as distance increses' ...
                        ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
            %to save memory
            clear parsedDataFiles errorBarToPresent ratio_mac_latency_fail
            disp('      ... in progress ...');
        end
            
        
        %------------------------------------------------------------------
        %7) draw the errobar for the broadcast mac-latency as a function of distance      
        if HAS_MAC_LATENCY_DATA == 1 && PKT_TYPES(pktTypeIndex) == BROADCAST
            errorBarToPresent = [];
            %get the files for all distances
            parsedDataFiles = dir(SOURCE_DATA_DIR);
            for fileIndex = 1:length(parsedDataFiles)  %per distances
                if parsedDataFiles(fileIndex).isdir
                    continue
                end
                shouldConsiderThisFile = 0;
                if ~NO_FILTERING_BASED_ON_FILE_PREFIX
                    for indYDist=1:length(Y_DISTS_ABS_TO_CONSIDER)
                        if ~isempty(strfind(parsedDataFiles(fileIndex).name, [PARSED_FILE_PREFIX num2str(Y_DISTS_ABS_TO_CONSIDER(indYDist))]))
                            shouldConsiderThisFile = 1;
                            break;
                        end
                    end
                end
                if shouldConsiderThisFile == 0
                    continue
                end
                if ~USE_UNIX_MATLAB
                    parsedData = load([SOURCE_DATA_DIR '\' parsedDataFiles(fileIndex).name]);
                else                     
                    parsedData = load([SOURCE_DATA_DIR '/' parsedDataFiles(fileIndex).name]);
                end
                sumData = parsedData.sumData;
                if TESTING_LINK_SYMMETRIC_SIMILARITY == 0
                    sumData.distance = abs(sumData.distance);
                end
                macLatencyBC = sumData.macLatencyBC;
                if isempty(macLatencyBC)
                    continue
                end
                %get the indices of the related data item
                itemsOfType = find(macLatencyBC(:, 1) == PKT_TYPES(pktTypeIndex));
                itemsOfSize = find(macLatencyBC(:, 2) == PKT_SIZES(pktSizeIndex));
                itemsToPresent = intersect(itemsOfType, itemsOfSize);
                if isempty(itemsToPresent)
                    continue
                end
                %fetch the feedback delay
                macLatencyToPresent = macLatencyBC(itemsToPresent, 3);  
                %save this data
                save(['macLatencyBC-' num2str(sumData.distance) '-' num2str(PKT_SIZES(pktSizeIndex)) '.mat'], 'macLatencyToPresent');
                %remove outliers
                macLatencyToPresent = macLatencyToPresent(find(macLatencyToPresent >= MIN_MAC_LATENCY));
                if SHOW_MAC_LATENCY_DETAIL
                    %draw the historgram
                    figure('Name', 'Histogram for broadcast mac-latency');
                    hist(macLatencyToPresent, 150);
                    title(['Histogram for broadcast mac-latency' '   distance = ' num2str(sumData.distance) ' feet']);
                end
                %put in erroBarToPresent
                len = size(errorBarToPresent, 1);
                errorBarToPresent(len+1, 1) = sumData.distance;
                errorBarToPresent(len+1, 2) = mean(macLatencyToPresent);
                errorBarToPresent(len+1, 3) = min(macLatencyToPresent);
                errorBarToPresent(len+1, 4) = max(macLatencyToPresent);
                %to save memory
                clear sumData macLatencyBC itemsToPresent macLatencyToPresent len 
            end %distances
            %present the error bar as a function of distance        
            if ~isempty(errorBarToPresent)
                errorBarToPresent = sortrows(errorBarToPresent, 1);
                mac_latency_bc = errorBarToPresent
                save('mac_latency_bc.mat', 'mac_latency_bc');

                figure('Name', 'MAC Latency for broadcast');
                errorbar(errorBarToPresent(:, 1), errorBarToPresent(:, 2)/1000, ...
                         errorBarToPresent(:, 2)/1000 - errorBarToPresent(:, 3)/1000, ...
                         errorBarToPresent(:, 4)/1000 - errorBarToPresent(:, 2)/1000);
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('distance (feet)');
                ylabel('MAC Latency (milliseconds)'); 
                title(['MAC Latency for broadcast' ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
                %And the normalized ratio of increase in mac latency as distance increases
                figure('Name', 'Ratio of increase in the mean MAC-latency-BC as distance increses');
                plot(errorBarToPresent(:, 1) / errorBarToPresent(1, 1), ...
                     errorBarToPresent(:, 2) / errorBarToPresent(1, 2));
                grid off;
                set(gca, 'FontSize', 30);
                xlabel('distance normalized to that of the closest receiver');
                ylabel('MAC latency normalized to that of the closest receiver');
                title(['Ratio of increase in the mean MAC-latency-BC as distance increses' ...
                        ';   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex))]);
            end
            %to save memory
            clear parsedDataFiles errorBarToPresent
            disp('      ... in progress ...');
        end
            
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %to improve performance
        pack
        
        disp(['  pkt-type = ' num2str(PKT_TYPES(pktTypeIndex)) '   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ': done!']);
        
    end %by packet sizes
end  %by packet types
%save data for further exploration
save('deliveryRateMeanStdCovMedian', 'deliveryRateMeanStdCovMedian');
save('macLatencyMeanStdCov', 'macLatencyMeanStdCov');
save('macLatencySuccMeanStdCov', 'macLatencySuccMeanStdCov');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SUB-FUNCTIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% To estimate unicast link reliability via that of broadcast, without
%% temporal link propeprties, i.e., assume independent packet loss
function estimation = UCQualityEstimationViaBC(BCQuality)
maxRetries = 8;

estimation = 1 - realpow(1 - BCQuality, maxRetries);
